/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "G\u0127arbi";
        final String metaValue_el = "Grieg";
        final String metaValue_ja = "\u0120appuni\u017c";
        final String metaValue_la = "Latin";
        final String metaValue_peo = "Persjan Antik";
        final String metaValue_Hant = "Tradizzjonali";
        final Object[][] data = new Object[][] {
            { "001", "Dinja" },
            { "002", "Affrika" },
            { "005", "Amerika t\u2019Isfel" },
            { "009", "O\u010bejanja" },
            { "011", "Affrika tal-Punent" },
            { "013", "Amerika \u010aentrali" },
            { "014", "Affrika tal-Lvant" },
            { "015", "Affrika ta\u2019 Fuq" },
            { "017", "Affrika Nofsani" },
            { "018", "Affrika t\u2019Isfel" },
            { "019", "Amerika" },
            { "029", "Karibew" },
            { "030", "Asja tal-Lvant" },
            { "034", "Asja t\u2019Isfel \u010aentrali" },
            { "035", "Asja tax-Xlokk" },
            { "039", "Ewropa t\u2019Isfel" },
            { "053", "Awstralja u New Zealand" },
            { "054", "Melanesja" },
            { "057", "Re\u0121jun ta\u2019 Mikrone\u017cja" },
            { "061", "Polinesja" },
            { "142", "Asja" },
            { "143", "Asja \u010aentrali" },
            { "145", "Asja tal-Punent" },
            { "150", "Ewropa" },
            { "151", "Ewropa tal-Lvant" },
            { "154", "Ewropa ta\u2019 Fuq" },
            { "155", "Ewropa tal-Punent" },
            { "419", "Amerika Latina" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "l-Emirati G\u0127arab Mag\u0127quda" },
            { "AF", "l-Afganistan" },
            { "AG", "Antigua u Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "l-Albanija" },
            { "AM", "l-Armenja" },
            { "AO", "l-Angola" },
            { "AQ", "l-Antartika" },
            { "AR", "l-Ar\u0121entina" },
            { "AS", "is-Samoa Amerikana" },
            { "AT", "l-Awstrija" },
            { "AU", "l-Awstralja" },
            { "AW", "Aruba" },
            { "AX", "il-G\u017cejjer Aland" },
            { "AZ", "l-A\u017cerbaj\u0121an" },
            { "BA", "il-Bo\u017cnija-\u0126erzegovina" },
            { "BB", "Barbados" },
            { "BD", "il-Bangladesh" },
            { "BE", "il-Bel\u0121ju" },
            { "BF", "il-Burkina Faso" },
            { "BG", "il-Bulgarija" },
            { "BH", "il-Bahrain" },
            { "BI", "il-Burundi" },
            { "BJ", "il-Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "il-Brunei" },
            { "BO", "il-Bolivja" },
            { "BQ", "in-Netherlands tal-Karibew" },
            { "BR", "Il-Bra\u017cil" },
            { "BS", "il-Bahamas" },
            { "BT", "il-Bhutan" },
            { "BV", "G\u017cira Bouvet" },
            { "BW", "il-Botswana" },
            { "BY", "il-Belarussja" },
            { "BZ", "il-Belize" },
            { "CA", "il-Kanada" },
            { "CC", "G\u017cejjer Cocos (Keeling)" },
            { "CD", "ir-Repubblika Demokratika tal-Kongo" },
            { "CF", "ir-Repubblika \u010aentru-Afrikana" },
            { "CG", "il-Kongo - Brazzaville" },
            { "CH", "l-I\u017cvizzera" },
            { "CI", "il-Kosta tal-Avorju" },
            { "CK", "G\u017cejjer Cook" },
            { "CL", "i\u010b-\u010aili" },
            { "CM", "il-Kamerun" },
            { "CN", "i\u010b-\u010aina" },
            { "CO", "il-Kolombja" },
            { "CP", "il-G\u017cira Clipperton" },
            { "CR", "il-Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "il-G\u017cira Christmas" },
            { "CY", "\u010aipru" },
            { "CZ", "ir-Repubblika \u010aeka" },
            { "DE", "il-\u0120ermanja" },
            { "DG", "Diego Garcia" },
            { "DJ", "il-Djibouti" },
            { "DK", "id-Danimarka" },
            { "DM", "Dominica" },
            { "DO", "ir-Repubblika Dominicana" },
            { "DZ", "l-Al\u0121erija" },
            { "EA", "Ceuta u Melilla" },
            { "EC", "l-Ekwador" },
            { "EE", "l-Estonja" },
            { "EG", "l-E\u0121ittu" },
            { "EH", "is-Sa\u0127ara tal-Punent" },
            { "ER", "l-Eritrea" },
            { "ES", "Spanja" },
            { "ET", "l-Etjopja" },
            { "EU", "Unjoni Ewropea" },
            { "FI", "il-Finlandja" },
            { "FJ", "Fi\u0121i" },
            { "FK", "il-G\u017cejjer Falkland" },
            { "FM", "il-Mikrone\u017cja" },
            { "FO", "il-G\u017cejjer Faeroe" },
            { "FR", "Franza" },
            { "GA", "il-Gabon" },
            { "GB", "ir-Renju Unit" },
            { "GD", "Grenada" },
            { "GE", "il-Georgia" },
            { "GF", "il-Guyana Fran\u010bi\u017ca" },
            { "GG", "Guernsey" },
            { "GH", "il-Ghana" },
            { "GI", "\u0120ibilt\u00e0" },
            { "GL", "Greenland" },
            { "GM", "il-Gambja" },
            { "GN", "il-Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "il-Guinea Ekwatorjali" },
            { "GR", "il-Gre\u010bja" },
            { "GS", "il-Georgia tan-Nofsinhar u l-G\u017cejjer Sandwich tan-Nofsinhar" },
            { "GT", "il-Gwatemala" },
            { "GU", "Guam" },
            { "GW", "il-Guinea-Bissau" },
            { "GY", "il-Guyana" },
            { "HK", "ir-Re\u0121jun Amministrattiv Spe\u010bjali ta\u2019 Hong Kong tar-Repubblika tal-Poplu ta\u010b-\u010aina" },
            { "HM", "il-G\u017cejjer Heard u l-G\u017cejjer McDonald" },
            { "HN", "il-Honduras" },
            { "HR", "il-Kroazja" },
            { "HT", "il-Haiti" },
            { "HU", "l-Ungerija" },
            { "IC", "il-G\u017cejjer Canary" },
            { "ID", "l-Indone\u017cja" },
            { "IE", "l-Irlanda" },
            { "IL", "I\u017crael" },
            { "IM", "Isle of Man" },
            { "IN", "l-Indja" },
            { "IQ", "l-Iraq" },
            { "IR", "l-Iran" },
            { "IS", "l-I\u017clanda" },
            { "IT", "l-Italja" },
            { "JE", "Jersey" },
            { "JM", "il-\u0120amajka" },
            { "JO", "il-\u0120ordan" },
            { "JP", "il-\u0120appun" },
            { "KE", "il-Kenja" },
            { "KG", "il-Kirgi\u017cistan" },
            { "KH", "il-Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts u Nevis" },
            { "KP", "il-Korea ta\u2019 Fuq" },
            { "KR", "il-Korea t\u2019Isfel" },
            { "KW", "il-Kuwajt" },
            { "KY", "il-G\u017cejjer Cayman" },
            { "KZ", "il-Ka\u017cakistan" },
            { "LA", "il-Laos" },
            { "LB", "il-Libanu" },
            { "LC", "Saint Lucia" },
            { "LI", "il-Liechtenstein" },
            { "LK", "is-Sri Lanka" },
            { "LR", "il-Liberja" },
            { "LS", "il-Lesoto" },
            { "LT", "il-Litwanja" },
            { "LU", "il-Lussemburgu" },
            { "LV", "il-Latvja" },
            { "LY", "il-Libja" },
            { "MA", "il-Marokk" },
            { "MC", "Monaco" },
            { "MD", "il-Moldova" },
            { "ME", "il-Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "G\u017cejjer Marshall" },
            { "MK", "il-Ma\u010bedonja ta\u2019 Fuq" },
            { "ML", "il-Mali" },
            { "MM", "il-Myanmar/Burma" },
            { "MN", "il-Mongolja" },
            { "MO", "ir-Re\u0121jun Amministrattiv Spe\u010bjali tal-Macao tar-Repubblika tal-Poplu ta\u010b-\u010aina" },
            { "MP", "\u0120\u017cejjer Mariana tat-Tramuntana" },
            { "MQ", "Martinique" },
            { "MR", "il-Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "il-Maldivi" },
            { "MW", "il-Malawi" },
            { "MX", "il-Messiku" },
            { "MY", "il-Malasja" },
            { "MZ", "il-Mozambique" },
            { "NA", "in-Namibja" },
            { "NC", "New Caledonia" },
            { "NE", "in-Ni\u0121er" },
            { "NF", "G\u017cira Norfolk" },
            { "NG", "in-Ni\u0121erja" },
            { "NI", "in-Nikaragwa" },
            { "NL", "in-Netherlands" },
            { "NO", "in-Norve\u0121ja" },
            { "NP", "in-Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "l-Oman" },
            { "PA", "il-Panama" },
            { "PE", "il-Per\u00f9" },
            { "PF", "Poline\u017cja Fran\u010bi\u017ca" },
            { "PG", "Papua New Guinea" },
            { "PH", "il-Filippini" },
            { "PK", "il-Pakistan" },
            { "PL", "il-Polonja" },
            { "PM", "Saint Pierre u Miquelon" },
            { "PN", "G\u017cejjer Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "it-Territorji Palestinjani" },
            { "PT", "il-Portugall" },
            { "PW", "Palau" },
            { "PY", "il-Paragwaj" },
            { "QA", "il-Qatar" },
            { "RE", "R\u00e9union" },
            { "RO", "ir-Rumanija" },
            { "RS", "is-Serbja" },
            { "RU", "ir-Russja" },
            { "RW", "ir-Rwanda" },
            { "SA", "l-Arabja Sawdija" },
            { "SB", "il-G\u017cejjer Solomon" },
            { "SC", "is-Seychelles" },
            { "SD", "is-Sudan" },
            { "SE", "l-I\u017cvezja" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "is-Slovenja" },
            { "SJ", "Svalbard u Jan Mayen" },
            { "SK", "is-Slovakkja" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "is-Senegal" },
            { "SO", "is-Somalja" },
            { "SR", "is-Suriname" },
            { "SS", "is-Sudan t\u2019Isfel" },
            { "ST", "S\u00e3o Tom\u00e9 u Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "is-Sirja" },
            { "SZ", "l-Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "il-G\u017cejjer Turks u Caicos" },
            { "TD", "i\u010b-Chad" },
            { "TF", "It-Territorji Fran\u010bi\u017ci tan-Nofsinhar" },
            { "TG", "it-Togo" },
            { "TH", "it-Tajlandja" },
            { "TJ", "it-Ta\u0121ikistan" },
            { "TK", "it-Tokelau" },
            { "TL", "Timor Leste" },
            { "TM", "it-Turkmenistan" },
            { "TN", "it-Tune\u017cija" },
            { "TO", "Tonga" },
            { "TR", "it-Turkija" },
            { "TT", "Trinidad u Tobago" },
            { "TV", metaValue_TV },
            { "TW", "it-Tajwan" },
            { "TZ", "it-Tanzanija" },
            { "UA", "l-Ukrajna" },
            { "UG", "l-Uganda" },
            { "UM", "Il-G\u017cejjer Minuri Mbieg\u0127da tal-Istati Uniti" },
            { "US", "l-Istati Uniti" },
            { "UY", "l-Urugwaj" },
            { "UZ", "l-U\u017cbekistan" },
            { "VA", "l-Istat tal-Belt tal-Vatikan" },
            { "VC", "Saint Vincent u l-Grenadini" },
            { "VE", "il-Venezwela" },
            { "VG", "il-G\u017cejjer Ver\u0121ni Brittani\u010bi" },
            { "VI", "il-G\u017cejjer Ver\u0121ni tal-Istati Uniti" },
            { "VN", "il-Vjetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis u Futuna" },
            { "WS", "Samoa" },
            { "XK", "il-Kosovo" },
            { "YE", "il-Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "l-Afrika t\u2019Isfel" },
            { "ZM", "i\u017c-\u017bambja" },
            { "ZW", "i\u017c-\u017bimbabwe" },
            { "ZZ", "Re\u0121jun Mhux Mag\u0127ruf" },
            { "aa", "Afar" },
            { "ab", "Abka\u017cjan" },
            { "ae", "Avestan" },
            { "af", "Afrikans" },
            { "ak", "Akan" },
            { "am", "Amhariku" },
            { "an", "Aragoni\u017c" },
            { "ar", metaValue_ar },
            { "as", "Assami\u017c" },
            { "av", "Avarik" },
            { "ay", "Aymara" },
            { "az", "A\u017cerbaj\u0121ani" },
            { "ba", "Bashkir" },
            { "be", "Belarussu" },
            { "bg", "Bulgaru" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibetjan" },
            { "br", "Breton" },
            { "bs", "Bo\u017cnijaku" },
            { "ca", "Katalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Korsiku" },
            { "cr", "Cree" },
            { "cs", "\u010aek" },
            { "cu", "Slaviku tal-Knisja" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Dani\u017c" },
            { "de", "\u0120ermani\u017c" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Ingli\u017c" },
            { "eo", "Esperanto" },
            { "es", "Spanjol" },
            { "et", "Estonjan" },
            { "eu", "Bask" },
            { "fa", "Persjan" },
            { "ff", "Fulah" },
            { "fi", "Finlandi\u017c" },
            { "fj", "Fi\u0121jan" },
            { "fo", "Faroese" },
            { "fr", "Fran\u010bi\u017c" },
            { "fy", "Frisian tal-Punent" },
            { "ga", "Irlandi\u017c" },
            { "gd", "Galliku Sko\u010b\u010bi\u017c" },
            { "gl", "Gali\u010bjan" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", "Ebrajk" },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroat" },
            { "ht", "Creole ta\u2019 Haiti" },
            { "hu", "Ungeri\u017c" },
            { "hy", "Armen" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indone\u017cjan" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupjak" },
            { "io", "Ido" },
            { "is", "I\u017clandi\u017c" },
            { "it", "Taljan" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "\u0120avani\u017c" },
            { "ka", "\u0120or\u0121jan" },
            { "kg", "Kongo" },
            { "ki", "Kikuju" },
            { "kj", "Kuanyama" },
            { "kk", "Ka\u017cak" },
            { "kl", "Kalallisut" },
            { "km", "Khmer" },
            { "kn", "Kannada" },
            { "ko", "Korean" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurd" },
            { "kv", "Komi" },
            { "kw", "Korniku" },
            { "ky", "Kirgi\u017c" },
            { "la", metaValue_la },
            { "lb", "Lussemburgi\u017c" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingaljan" },
            { "lo", "Laosjan" },
            { "lt", "Litwan" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvjan" },
            { "mg", "Malagasy" },
            { "mh", "Marshalljani\u017c" },
            { "mi", "Maori" },
            { "mk", "Ma\u010bedonjan" },
            { "ml", "Malayalam" },
            { "mn", "Mongoljan" },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Malti" },
            { "my", "Burmi\u017c" },
            { "na", "Naurujan" },
            { "nb", "Bokmal Norve\u0121i\u017c" },
            { "nd", "Ndebeli tat-Tramuntana" },
            { "ne", "Nepali\u017c" },
            { "ng", "Ndonga" },
            { "nl", "Olandi\u017c" },
            { "nn", "Ninorsk Norve\u0121i\u017c" },
            { "no", "Norve\u0121i\u017c" },
            { "nr", "Ndebele tan-Nofsinhar" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "O\u010b\u010bitan" },
            { "oj", "O\u0121ibwa" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Ossettiku" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Pollakk" },
            { "ps", "Pashto" },
            { "pt", "Portugi\u017c" },
            { "qu", "Quechua" },
            { "rm", "Romanz" },
            { "rn", "Rundi" },
            { "ro", "Rumen" },
            { "ru", "Russu" },
            { "rw", "Kinjarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinjan" },
            { "sd", "Sindhi" },
            { "se", "Sami tat-Tramuntana" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroat" },
            { "si", "Sinhala" },
            { "sk", "Slovakk" },
            { "sl", "Sloven" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albani\u017c" },
            { "sr", "Serb" },
            { "ss", "Swati" },
            { "st", "Soto tan-Nofsinhar" },
            { "su", "Sundani\u017c" },
            { "sv", "\u017bvedi\u017c" },
            { "sw", "Swahili" },
            { "ta", "Tamil" },
            { "te", "Telugu" },
            { "tg", "Ta\u0121ik" },
            { "th", "Tajlandi\u017c" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmeni" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Tork" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Ta\u0127itjan" },
            { "ug", "Uyghur" },
            { "uk", "Ukren" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vjetnami\u017c" },
            { "vo", "Volapuk" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "\u010aini\u017c" },
            { "zu", "Zulu" },
            { "ace", "A\u010bini\u017c" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "afh", "Afri\u0127ili" },
            { "agq", "Aghem" },
            { "ain", "Ajnu" },
            { "akk", "Akkadjen" },
            { "ale", "Aleut" },
            { "alt", "Altai tan-Nofsinhar" },
            { "ang", "Ingli\u017c Antik" },
            { "anp", "Angika" },
            { "arc", "Aramajk" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "arw", "Arawak" },
            { "asa", "Asu" },
            { "ast", "Asturian" },
            { "awa", "Awadhi" },
            { "bal", "Balu\u010bi" },
            { "ban", "Balini\u017c" },
            { "bas", "Basa" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bla", "Siksika" },
            { "bra", "Braj" },
            { "brx", "Bodo" },
            { "bua", "Burjat" },
            { "bug", "Buginese" },
            { "byn", "Blin" },
            { "cad", "Kaddo" },
            { "car", "Karib" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "\u010auki\u017c" },
            { "chm", "Mari" },
            { "chn", "Chinook Jargon" },
            { "cho", "Choctaw" },
            { "chp", "\u010aipewjan" },
            { "chr", "Cherokee" },
            { "chy", "Cheyenne" },
            { "ckb", "Kurd \u010aentrali" },
            { "cop", "Koptiku" },
            { "crh", "Tork tal-Krimea" },
            { "crs", "Fran\u010bi\u017c tas-Seselwa Creole" },
            { "csb", "Kashubian" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delawerjan" },
            { "den", "Slav" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Sorbjan Komuni" },
            { "dua", "Dwala" },
            { "dum", "Olandi\u017c Medjevali" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "E\u0121izzjan (Antik)" },
            { "eka", "Ekajuk" },
            { "elx", "Elamit" },
            { "enm", "Ingli\u017c Medjevali" },
            { "ewo", "Ewondo" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filippin" },
            { "fon", "Fon" },
            { "frm", "Fran\u010bi\u017c Medjevali" },
            { "fro", "Fran\u010bi\u017c Antik" },
            { "fur", "Frijuljan" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gez", "Geez" },
            { "gil", "Gilbertjan" },
            { "gmh", "\u0120ermani\u017c Medjevali Pulit" },
            { "goh", "\u0120ermani\u017c Antik, Pulit" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", "Gotiku" },
            { "grb", "Grebo" },
            { "grc", "Grieg, Antik" },
            { "gsw", "\u0120ermani\u017c tal-I\u017cvizzera" },
            { "guz", "Gusii" },
            { "gwi", "Gwi\u010bin" },
            { "hai", "Haida" },
            { "haw", "\u0126awajjan" },
            { "hil", "Hiligaynon" },
            { "hit", "Hittite" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbjan ta\u2019 Fuq" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Lhudi-Persjan" },
            { "jrb", "Lhudi-G\u0127arbi" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabuljan" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Cape Verdjan" },
            { "kfo", "Koro" },
            { "kha", "Khasi" },
            { "kho", "Kotani\u017c" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kos", "Kosrejan" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Kareljan" },
            { "kru", "Kurux" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Kolonjan" },
            { "kum", "Kumyk" },
            { "kut", "Kutenaj" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Le\u017cgjan" },
            { "lkt", "Lakota" },
            { "lol", "Mongo" },
            { "loz", "Lo\u017ci" },
            { "lrc", "Luri tat-Tramuntana" },
            { "lua", "Luba-Luluwa" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Maduri\u017c" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Irlandi\u017c Medjevali" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Met\u00e0" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mnc", "Manchu" },
            { "mni", "Manipuri" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Lingwi Diversi" },
            { "mus", "Kriek" },
            { "mwl", "Mirandi\u017c" },
            { "mwr", "Marwari" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nap", "Naplitan" },
            { "naq", "Nama" },
            { "nds", "\u0120ermani\u017c Komuni" },
            { "new", "Newari" },
            { "nia", "Nijas" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Nors Antik" },
            { "nqo", "N\u2019Ko" },
            { "nso", "Soto tat-Tramuntana" },
            { "nus", "Nuer" },
            { "nwc", "Newari Klassiku" },
            { "nym", "Njamwe\u017ci" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osa\u0121jan" },
            { "ota", "Tork Ottoman" },
            { "pag", "Pangasinjan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palawjan" },
            { "pcm", "Pidgin Ni\u0121erjan" },
            { "peo", metaValue_peo },
            { "phn", "Feni\u010bju" },
            { "pon", "Ponpejan" },
            { "prg", "Prussu" },
            { "pro", "Provenzal Antik" },
            { "quc", "K\u2019iche\u2019" },
            { "raj", "Ra\u0121astani" },
            { "rap", "Rapanwi" },
            { "rar", "Rarotongani" },
            { "rof", "Rombo" },
            { "rom", "Romanesk" },
            { "rup", "Aromanjan" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sam", "Samaritan Aramajk" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sqalli" },
            { "sco", "Sko\u010b\u010bi\u017c" },
            { "seh", "Sena" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Irlandi\u017c Antik" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "sid", "Sidamo" },
            { "sma", "Sami tan-Nofsinhar" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdien" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssy", "Saho" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Sumerjan" },
            { "swb", "Komorjan" },
            { "syr", "Sirjan" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelau" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "tsi", "Tsimshian" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinjan" },
            { "tzm", "Tamazight tal-Atlas \u010aentrali" },
            { "udm", "Udmurt" },
            { "uga", "Ugaritiku" },
            { "umb", "Umbundu" },
            { "und", "Lingwa Mhix Mag\u0127rufa" },
            { "vai", "Vai" },
            { "vot", "Votik" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Walamo" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapese" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yue", "Kantoni\u017c" },
            { "zap", "Zapotec" },
            { "zen", "Zenaga" },
            { "zgh", "Tamazight Standard tal-Marokk" },
            { "zun", "Zuni" },
            { "zxx", "Bla kontenut lingwistiku" },
            { "zza", "Zaza" },
            { "Arab", metaValue_ar },
            { "Brai", "Braille" },
            { "Cyrl", "\u010airilliku" },
            { "Grek", metaValue_el },
            { "Hans", "Simplifikat" },
            { "Hant", metaValue_Hant },
            { "Jpan", metaValue_ja },
            { "Latn", metaValue_la },
            { "Xpeo", metaValue_peo },
            { "Zxxx", "Mhux Miktub" },
            { "Zyyy", "Komuni" },
            { "Zzzz", "Kitba Mhux Mag\u0127rufa" },
            { "de_AT", "\u0120ermani\u017c Awstrijak" },
            { "de_CH", "\u0120ermani\u017c \u017bvizzeru" },
            { "en_AU", "Ingli\u017c Awstraljan" },
            { "en_CA", "Ingli\u017c Kanadi\u017c" },
            { "en_GB", "Ingli\u017c Brittaniku" },
            { "en_US", "Ingli\u017c Amerikan" },
            { "es_ES", "Spanjol Ewropew" },
            { "es_MX", "Spanjol tal-Messiku" },
            { "fr_CA", "Fran\u010bi\u017c Kanadi\u017c" },
            { "fr_CH", "Fran\u010bi\u017c \u017bvizzeru" },
            { "nl_BE", "Fjamming" },
            { "pt_BR", "Portugi\u017c tal-Bra\u017cil" },
            { "pt_PT", "Portugi\u017c Ewropew" },
            { "ro_MD", "Moldovan" },
            { "sw_CD", "Swahili tar-Repubblika Demokratika tal-Kongo" },
            { "ar_001", "G\u0127arbi Standard Modern" },
            { "es_419", "Spanjol Latin Amerikan" },
            { "key.ca", "Kalendarju" },
            { "key.co", "Kollazjoni" },
            { "key.cu", "Munita" },
            { "nds_NL", "Sassonu Komuni" },
            { "zh_Hans", "\u010aini\u017c Simplifikat" },
            { "zh_Hant", "\u010aini\u017c Tradizzjonali" },
            { "%%REVISED", "Ortografija Irriveda" },
            { "type.nu.latn", "Numri tal-Punent" },
            { "type.ca.dangi", "Kalendarju Dangi" },
            { "type.ca.hebrew", "Kalendarju Ebrajk" },
            { "type.co.pinyin", "Ordni tal-Pinjin" },
            { "type.co.stroke", "Ordni Ma\u0127\u017cu\u017ca" },
            { "type.ca.chinese", "Kalendarju \u010aini\u017c" },
            { "type.ca.iso8601", "Kalendarju ISO-8601" },
            { "type.co.big5han", "Ordni \u010aini\u017c Tradizzjonali (Big5)" },
            { "type.ca.buddhist", "Kalendarju Buddist" },
            { "type.ca.ethiopic", "Kalendarju Etjopiku" },
            { "type.ca.japanese", "Kalendarju \u0120appuni\u017c" },
            { "type.co.standard", "Ordni Standard" },
            { "type.ca.gregorian", "Kalendarju Gregorjan" },
            { "type.co.gb2312han", "Ordni \u010aini\u017c Sempli\u010bi (GB2312)" },
            { "type.co.phonebook", "Ordni Telefonika" },
            { "type.co.traditional", metaValue_Hant },
        };
        return data;
    }
}
